
using System;
using System.Collections.Generic;
using System.Text;
using Gemini.Core.BL.Interface.DBD;

namespace PI.ZB.N1200.ELearning.BL.DAL
{
    internal class EvaluationSheet : PI.FM.N000.Base.BL.DAL.BaseTable<DBD.EvaluationSheet, BO.EvaluationSheet>
    {

        internal EvaluationSheet(Gemini.Core.BL.Interface.IBusinessLogicPlugIn BusinessLogicPlugIn) : this(BusinessLogicPlugIn.Environment, BusinessLogicPlugIn.DriverName) { }

        internal EvaluationSheet(Gemini.Core.BL.Interface.DAL.IEnvironment Environment, string DriverName) : base(Environment, DriverName, DBD.EvaluationSheet.DBD) { }

        internal BO.EvaluationSheet RestoreTopOne(BO.EvaluationSheet.Search Search)
        {
            return InternalRestoreOne((int)DBD.EvaluationSheet.Commands.RestoreBySearch,
            delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
            {
                Command["PointPercent"].Value = Search.PointPercent;
                Command["Weight"].Value = Search.Weight;
            });
        }

        internal List<BO.EvaluationSheet> Restore(BO.EvaluationSheet.Search Search)
        {
            return InternalRestoreList((int)DBD.EvaluationSheet.Commands.RestoreBySearch,
          delegate(Gemini.Core.BL.Interface.DBD.ICommand Command)
          {
              Command["PointPercent"].Value = Search.PointPercent;
              Command["Weight"].Value = Search.Weight;
          });
        }

    }
}
